%-------------------------------------------------------------------------%
% Filename: figs_App_D_4_plot.m  
% Part of the paper "CS4ML: A general framework for active learning with
% arbitrary data based on Christoffel functions"
% 
% Description: generates the plots for Figure 12 in Appendix D, training 
% error versus the number of epochs.
%-------------------------------------------------------------------------%
clear all; close all; clc;
addpath(genpath('../../utils'));

% Loop over subfigures % 
for fig_num = 4
    for row_num = 1:3
        for col_num = 1:2
    
            fig_name = ['fig_AppD','_', num2str(fig_num),'_',num2str(row_num),'_',num2str(col_num)];
            load(['../../data/Figure App D 4/',fig_name])
    
            fig = figure();
            
            nb_trials = 20;
            
            for t = 1:nb_trials
                [ms, lw, fs, colors, markers, AlphaLevel] = get_fig_param_D_4();
                semilogy(x_values_data(:,1,1),y_values_data(:,t,1),'Color',colors{1}); hold on;
                semilogy(x_values_data(:,1,1),y_values_data(:,t,2),'Color',colors{2}); hold on;
                semilogy(x_values_data(:,1,1),y_values_data(:,t,3),'Color',colors{3}); hold on;
                semilogy(x_values_data(:,1,1),y_values_data(:,t,4),'Color',colors{4}); hold on;
            end
            grid on;
            
            for nb_ep = 1:9
                semilogy(z_values_data(nb_ep)*ones(9,1),linspace(1e-8,1e4,9),'k');
                hold on
            end
            
            set_legend_D_4
            set_font_fig_AppD_4 
            saveas(fig,['../../figs/Figure App D 4/',fig_name],'epsc');
        end
    end
end